<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ClienteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    
     public function rules(): array
     {
         return [
             'nomeC'=>'required',
             'nID'=> 'required',
             'tipoID'=> 'required',
             'genero'=> 'required',
             'dataNasc'=> 'required',
             'tipoConta'=> 'required',
             'contactoPrimario'=> 'required',
             'email'=> 'required|email',
             'telefone'=> 'required',
         ];
     }
 
     public function messages(): array
     {
         return[
             'nomeC.required'=>'Campo Nome Completo é obrigatório',
             'nID.required'=>'Campo Nº de Identificação é obrigatório',
             'tipoID.required'=>'Campo Tipo de Identificação é obrigatório',
             'genero.required'=>'Campo Nº de Genero é obrigatório',
             'dataNasc.required'=>'Campo Data de Nascimento é obrigatório',
             'tipoConta.required'=>'Campo Tipo de Conta é obrigatório',
             'contactoPrimario.required'=>'Campo Contacto Primário é obrigatório',
             'email.required'=>'Campo E-mail é obrigatório',
             'email.email'=>'Necessário enviar e-mail válido',
             'telefone.required'=>'Campo Telefone é obrigatório',
         ];
 
     }
}
