<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pessoais', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('nID')->unique();
            $table->string('tipoID');
            $table->string('genero');
            $table->date('dataNasc');
            $table->string('tipoConta');
            $table->string('contactoPrimario');
            $table->string('status');
            $table->string('email')->unique();
            $table->string('telefone')->unique();
            $table->longText('obs');
           // $table->foreignId('id_user')->constrained('users')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pessoais');
    }
};
