<!-- Fullscreen Modal para Editar Saída de Caixa -->
<div class="modal fade exampleModalFullscreenEdit" tabindex="-1" aria-labelledby="exampleModalFullscreenEditLabel" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #0b6631">
                <h5 class="modal-title text-white" id="exampleModalFullscreenEditLabel">EDITAR SAÍDA DE CAIXA</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="" method="POST" id="updateSaidaCaixaForm" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="saidaCaixaId" id="saidaCaixaId">
                    
                    <div class="row">
                        <!-- Referência e Data -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="referencia_edit" class="form-label">Referência</label>
                                <input type="text" class="form-control" id="referencia_edit" name="referencia" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="data_edit" class="form-label">Data</label>
                                <input type="datetime-local" class="form-control" id="data_edit" name="data" required>
                            </div>
                        </div>
                        
                        <!-- Descrição e Observação -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="descritivo_edit" class="form-label">Descrição</label>
                                <input type="text" class="form-control" id="descritivo_edit" name="descritivo" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="observacao_edit" class="form-label">Observação</label>
                                <input type="text" class="form-control" id="observacao_edit" name="observacao">
                            </div>
                        </div>
                        
                        <!-- Valor e Centro de Custo -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="valor_edit" class="form-label">Valor</label>
                                <input type="number" step="0.01" class="form-control" id="valor_edit" name="valor" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="centros_custo_id_edit" class="form-label">Centro de Custo</label>
                                <select class="form-select" id="centros_custo_id_edit" name="centros_custo_id" required>
                                    <option value="">Selecione um centro de custo</option>
                                    @foreach($centrosCusto as $centro)
                                        <option value="{{ $centro->id }}">{{ $centro->nome }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        
                        <!-- Usuário e Recebido Por -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="users_id_edit" class="form-label">Emitido por</label>
                                <select class="form-select" id="users_id_edit" name="users_id" required>
                                    <option value="">Selecione um usuário</option>
                                    @foreach($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="recebido_por_edit" class="form-label">Recebido por</label>
                                <input type="text" class="form-control" id="recebido_por_edit" name="recebido_por" required>
                            </div>
                        </div>
                        
                        <!-- Suporte Documental -->
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="suporte_documental_edit" class="form-label">Suporte Documental</label>
                                <input type="file" class="form-control" id="suporte_documental_edit" name="suporte_documental">
                                <div class="mt-2" id="documentoAtual">
                                    <p class="text-muted">Nenhum documento atual</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Assinatura -->
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="signature-pad-edit" class="form-label">Assinatura</label>
                                <div class="border rounded p-3">
                                    <div class="mb-2">
                                        <canvas id="signature-pad-edit" class="signature-pad" width=400 height=200></canvas>
                                    </div>
                                    <div>
                                        <button type="button" class="btn btn-danger btn-sm clear-button-edit">Limpar</button>
                                    </div>
                                    <input type="hidden" name="assinatura" id="signature_code_edit">
                                </div>
                                <div class="mt-2" id="assinaturaAtual">
                                    <p class="text-muted">Nenhuma assinatura atual</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal-footer mt-3">
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-success">Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inicializar o pad de assinatura quando o modal for aberto
    var signaturePadEdit = null;
    
    $('.exampleModalFullscreenEdit').on('shown.bs.modal', function (e) {
        var canvas = document.getElementById('signature-pad-edit');
        signaturePadEdit = new SignaturePad(canvas);
        
        // Preencher o campo oculto quando o formulário for enviado
        document.getElementById('updateSaidaCaixaForm').addEventListener('submit', function() {
            if (!signaturePadEdit.isEmpty()) {
                document.getElementById('signature_code_edit').value = signaturePadEdit.toDataURL();
            }
        });
        
        // Limpar o pad de assinatura
        document.querySelector('.clear-button-edit').addEventListener('click', function() {
            signaturePadEdit.clear();
        });
        
        // Obter o ID do botão que abriu o modal
        var button = e.relatedTarget;
        var saidaCaixaId = button.getAttribute('data-id');
        document.getElementById('saidaCaixaId').value = saidaCaixaId;
        
        // Definir a URL de ação do formulário
        document.getElementById('updateSaidaCaixaForm').action = '/scaixa/' + saidaCaixaId;
        
        // Carregar dados da saída de caixa
        fetch('/scaixa-detalhe/' + saidaCaixaId)
            .then(response => response.json())
            .then(data => {
                // Preencher os campos com os dados existentes
                document.getElementById('referencia_edit').value = data.referencia;
                document.getElementById('data_edit').value = formatDateTime(data.data);
                document.getElementById('descritivo_edit').value = data.descritivo;
                document.getElementById('observacao_edit').value = data.observacao || '';
                document.getElementById('valor_edit').value = data.valor;
                document.getElementById('centros_custo_id_edit').value = data.centros_custo_id;
                document.getElementById('users_id_edit').value = data.users_id;
                document.getElementById('recebido_por_edit').value = data.recebido_por;
                
                // Mostrar documento atual se existir
                if (data.suporte_documental) {
                    document.getElementById('documentoAtual').innerHTML = 
                        '<div class="alert alert-info">' +
                        '<p>Documento atual: <a href="/Doc/ComprovativoSaidaCaixa/' + data.suporte_documental + '" target="_blank">' +
                        '<i class="ri-file-pdf-2-line" style="font-size: 24px"></i> Ver documento</a></p>' +
                        '<p class="text-muted">Envie um novo documento apenas se desejar substituir o atual.</p>' +
                        '</div>';
                } else {
                    document.getElementById('documentoAtual').innerHTML = 
                        '<div class="alert alert-warning">Nenhum documento anexado</div>';
                }
                
                // Mostrar assinatura atual se existir
                if (data.assinatura) {
                    document.getElementById('assinaturaAtual').innerHTML = 
                        '<div class="alert alert-info">' +
                        '<p>Assinatura atual:</p>' +
                        '<img src="' + data.assinatura + '" style="max-width: 100%; height: auto; max-height: 100px;" />' +
                        '<p class="text-muted">Assine novamente apenas se desejar substituir a assinatura atual.</p>' +
                        '</div>';
                } else {
                    document.getElementById('assinaturaAtual').innerHTML = 
                        '<div class="alert alert-warning">Nenhuma assinatura registrada</div>';
                }
            })
            .catch(error => console.error('Erro ao carregar dados:', error));
    });
    
    // Limpar o modal quando fechado
    $('.exampleModalFullscreenEdit').on('hidden.bs.modal', function () {
        if (signaturePadEdit) {
            signaturePadEdit.clear();
        }
        document.getElementById('updateSaidaCaixaForm').reset();
        document.getElementById('documentoAtual').innerHTML = '<p class="text-muted">Nenhum documento atual</p>';
        document.getElementById('assinaturaAtual').innerHTML = '<p class="text-muted">Nenhuma assinatura atual</p>';
    });
    
    // Função para formatar data e hora para o formato do input datetime-local
    function formatDateTime(dateTimeString) {
        const date = new Date(dateTimeString);
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const day = String(date.getDate()).padStart(2, '0');
        const hours = String(date.getHours()).padStart(2, '0');
        const minutes = String(date.getMinutes()).padStart(2, '0');
        
        return `${year}-${month}-${day}T${hours}:${minutes}`;
    }
});
</script>
