<!-- View User Modal -->
<div class="modal fade exampleModalFullscreen2" tabindex="-1" aria-labelledby="exampleModalFullscreenLabel2" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #697175">
                <h5 class="modal-title text-white" id="exampleModalFullscreenLabel2">VISUALIZAR UTILIZADOR</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row g-3">
                    <!-- Dados Pessoais -->
                    <div class="col-md-12">
                        <h4>Dados Pessoais</h4>
                        <hr>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label fw-bold">Nome Completo</label>
                        <p id="view_name" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-bold">Número de Identificação</label>
                        <p id="view_nID" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-bold">Tipo de Documento</label>
                        <p id="view_tipoID" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-bold">Género</label>
                        <p id="view_genero" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-bold">Data de Nascimento</label>
                        <p id="view_dataNasc" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-bold">Telefone</label>
                        <p id="view_telefone" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label fw-bold">Contacto Primário</label>
                        <p id="view_contactoPrimario" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label fw-bold">Status</label>
                        <p id="view_status" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label fw-bold">Data de Cadastro</label>
                        <p id="view_created_at" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-12">
                        <label class="form-label fw-bold">Observações</label>
                        <div id="view_obs" class="form-control bg-light" style="min-height: 100px;"></div>
                    </div>

                    <!-- Dados de Acesso -->
                    <div class="col-md-12">
                        <h4>Dados de Acesso</h4>
                        <hr>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label fw-bold">E-mail</label>
                        <p id="view_email" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label fw-bold">Tipo de Conta</label>
                        <p id="view_tipoConta" class="form-control bg-light"></p>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label fw-bold">Permissões</label>
                        <div id="view_permissoes" class="form-control bg-light"></div>
                    </div>
                    
                    <div class="col-12 text-end">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Capturar o evento de exibição do modal para buscar os dados do utilizador
        $('.exampleModalFullscreen2').on('show.bs.modal', function (event) {
            const button = $(event.relatedTarget);
            const userId = button.data('id');
            
            // Buscar os dados do utilizador
            fetch(`/users/${userId}`)
                .then(response => response.json())
                .then(data => {
                    // Formatando a data de criação
                    const createdAt = new Date(data.created_at);
                    const formattedDate = createdAt.toLocaleDateString('pt-AO') + ' ' + createdAt.toLocaleTimeString('pt-AO');
                    
                    // Formatando a data de nascimento
                    const dataNasc = new Date(data.pessoa.dataNasc);
                    const formattedNascDate = dataNasc.toLocaleDateString('pt-AO');
                    
                    // Preencher os campos com os dados do utilizador
                    document.getElementById('view_name').textContent = data.name;
                    document.getElementById('view_email').textContent = data.email;
                    document.getElementById('view_nID').textContent = data.pessoa.nID;
                    document.getElementById('view_tipoID').textContent = data.pessoa.tipoID;
                    document.getElementById('view_genero').textContent = data.pessoa.genero;
                    document.getElementById('view_dataNasc').textContent = formattedNascDate;
                    document.getElementById('view_telefone').textContent = data.pessoa.telefone;
                    document.getElementById('view_contactoPrimario').textContent = data.pessoa.contactoPrimario;
                    document.getElementById('view_status').textContent = data.pessoa.status === 'on' ? 'Ativo' : 'Inativo';
                    document.getElementById('view_tipoConta').textContent = data.pessoa.tipoConta;
                    document.getElementById('view_obs').textContent = data.pessoa.obs || 'Nenhuma observação registrada';
                    document.getElementById('view_created_at').textContent = formattedDate;
                    
                    // Exibir permissões
                    let permissoes = [];
                    if (data.admin) permissoes.push('Administrador');
                    if (data.client) permissoes.push('Cliente');
                    if (!data.admin && !data.client) permissoes.push('Operador');
                    
                    document.getElementById('view_permissoes').textContent = permissoes.join(', ');
                })
                .catch(error => {
                    console.error('Error fetching user data:', error);
                    Swal.fire({
                        title: 'Erro',
                        text: 'Ocorreu um erro ao carregar os dados do utilizador.',
                        icon: 'error'
                    });
                });
        });
    });
</script>
