@extends('Layout.LayoutBaseAdmin')


@section('Conteudo')
   

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">SERVLUANDA,Lda - PA HONGA</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
                                        <li class="breadcrumb-item active">Gestão de Utilizadores</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <!-- Mensagens do sistema -->

                    @if (session('msg'))
                        
                    <script>
                        document.addEventListener('DOMContentLoaded',()=>{
                            Swal.fire({
                                title: "Pronto",
                                text: "{{ session('msg') }}",
                                icon: "success",
                                confirmButtonColor: "#3085d6",
                                confirmButtonText: "OK",
                            });
                        });
                    </script>

                    @endif

                    @if (session('error'))
                        
                    <script>
                        document.addEventListener('DOMContentLoaded',()=>{
                            Swal.fire({
                                title: "Erro",
                                text: "{{ session('error') }}",
                                icon: "error",
                                confirmButtonColor: "#3085d6",
                                confirmButtonText: "OK",
                            });
                        });
                    </script>

                    @endif
                    

                   
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card card-height-100">
                                <div class="card-header d-flex align-items-center ">
                                    <h4 class="card-title flex-grow-1 mb-0">Utilizadores do Sistema</h4>

                                    <div class="hstack flex-wrap gap-2 mb-3 mb-lg-0" >

                                        <button type="button" class="btn btn-success btn-label"  data-bs-toggle="modal" data-bs-target=""><i class=" ri-search-eye-line label-icon align-middle fs-16 me-2"></i>Busca parametrizada &nbsp; &nbsp; &nbsp;</button>
                                          
                                        <button type="button" class="btn btn-primary btn-label"  data-bs-toggle="modal" data-bs-target=".exampleModalFullscreen"><i class=" ri-add-fill label-icon align-middle fs-16 me-2"></i>Novo Utilizador &nbsp; &nbsp; &nbsp;</button>
                                       
                                    </div>
                                    
                                </div><!-- end cardheader -->
                                <div class="card-body">
                                    <div class="table-responsive table-card">
                                        <table  class="table table-nowrap table-centered align-middle">
                                            <thead class="bg-light text-muted">
                                                <tr>
                                                    <th scope="col">ID</th>
                                                    <th scope="col">Nome</th>
                                                    <th scope="col">Email</th>
                                                    <th scope="col">Telefone</th>
                                                    <th scope="col">Perfil</th>
                                                    <th scope="col">Nº Identificação</th>
                                                    <th scope="col">Status</th>
                                                    <th scope="col" style="width: 12%;">Ações</th>
                                                </tr><!-- end tr -->
                                            </thead><!-- thead -->

                                            <tbody>
                                                
                                                @forelse( $users as $user )
                                                    <tr><!-- tr -->
                                                        <td class="fw-medium">{{ $user->id }}</td>
                                                        <td class="fw-medium">{{ $user->name }}</td>
                                                        <td class="fw-medium">{{ $user->email }}</td>
                                                        <td class="fw-medium">{{ $user->pessoa->telefone }}</td>
                                                        <td class="fw-medium">
                                                            @if($user->admin)
                                                                <span class="badge bg-success">Administrador</span>
                                                            @elseif($user->client)
                                                                <span class="badge bg-info">Cliente</span>
                                                            @else
                                                                <span class="badge bg-secondary">Operador</span>
                                                            @endif
                                                        </td>
                                                        <td class="fw-medium">{{ $user->pessoa->nID }}</td>
                                                        <td class="fw-medium">
                                                            @if ($user->pessoa->status =='on')
                                                                <i class="ri-check-double-line" style="font-size: 18px; color: #06b41e;"></i> 
                                                            @else
                                                                <i class="ri-prohibited-line" style="font-size: 18px; color: #c20303;"></i>
                                                            @endif
                                                        </td>
                                                        <td class="text-muted">
                                                            <!-- Buttons Group -->
                                                            <button type="button" style="background-color: #697175" class="btn btn-primary waves-effect waves-effect"  data-bs-toggle="modal" data-bs-target=".exampleModalFullscreen2" data-id="{{ $user->id }}"><i class="ri-eye-line" data-bs-toggle="tooltip"  data-bs-placement="top" title="Visualizar"></i></button>
                                                            <button type="button" class="btn btn-success waves-effect waves-light" data-bs-toggle="modal" data-bs-target=".exampleModalFullscreen1" data-id="{{ $user->id }}"><i class="ri-edit-box-line" data-bs-toggle="tooltip" data-bs-placement="top" title="Editar"></i></button>
                                                            <form action="{{ route('users.destroy', $user->id) }}" method="POST" style="display: inline;">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger btn-icon waves-effect waves-light" data-bs-toggle="tooltip" data-bs-placement="top" title="Excluir" onclick="return confirm('Tem certeza que deseja excluir este utilizador?');"><i class="ri-delete-bin-6-line"></i></button>
                                                            </form>
                                                        </td>
                                                    </tr>

                                                    @empty

                                                    <tr>
                                                        <td colspan="8">Nenhum registro foi encontrado...</td>
                                                    </tr>
                                                    
                                                @endforelse
                                                
                                            </tbody><!-- end tbody -->
                                        </table><!-- end table -->
                                    </div>

                                    <div class="align-items-center mt-xl-3 mt-4 justify-content-between d-flex">
                                       
                                    </div>
                                    {{ $users->onEachSide(10)->links()}}
                                </div><!-- end card body -->
                            </div><!-- end card -->
                        </div><!-- end col -->
                       
                    </div><!-- end row -->

                </div>
                <!-- container-fluid -->
                @include("Administracao.ComponentesAdmin.Users.Cpt_CreateUser")
                @include("Administracao.ComponentesAdmin.Users.Cpt_EditUser")
                @include("Administracao.ComponentesAdmin.Users.Cpt_ViewUser")
            </div>
           
          


   @endsection
