<?php

use App\Http\Controllers\AcessoController;
use App\Http\Controllers\BancoController;
use App\Http\Controllers\EmpresaController;
use App\Http\Controllers\HomeClienteController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PagamentotaxasController;
use App\Http\Controllers\SaidaCaixaController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ComprovativoPagamentoController;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// ROTAS PUBLICAS

Route::get('/mail', function () {
    Mail::send('Mail.NotificacaoCobranca', ['curso' => 'vALERY'], function ($m) {
        $m->to('cvalery.servluanda@gmail.com', 'Valery Tseyi');
        $m->subject('Condomínio');
    });
    dd('Sucesso');
    // return view('Mail.NotificacaoCobranca');
});
// Rotas de Controle de acesso
Route::get('/', [AcessoController::class, 'index'])->name('login');
Route::post('/login', [AcessoController::class, 'loginProcess'])->name('loginProcess');

// ROTAS PRIVADAS DEFINIDAS POR GRUPOS DE USUÁRIOS (ADMINISTRADORES)

Route::group(['middleware' => 'admin'], function () {

    // Logout do APP
    Route::get('/logout', [AcessoController::class, 'logoutProcess'])->name('logoutProcess');

    // Rotas da homePage de Administração
    Route::get('/HomeAdmin', [HomeController::class, 'index'])->name('home');

    // Rotas Empresas
    Route::get('/Empresa', [EmpresaController::class, 'index'])->name('empresa'); // LISTAR EMPRESAS
    Route::post('/store-Empresa', [EmpresaController::class, 'store'])->name('empresa-store'); // CADASTRAR EMPRESAS

    // Rotas Bancos
    Route::get('/Banco', [BancoController::class, 'index'])->name('banco'); // LISTAR BANCOS
    Route::post('/store-Banco', [BancoController::class, 'store'])->name('banco-store'); // CADASTRAR BANCOS

    // Saidas de Caixa
    Route::get('/scaixa', [SaidaCaixaController::class, 'index'])->name('fluxoCaixa'); // LISTAR SAIDAS DE CAIXA
    Route::get('/scaixa-search', [SaidaCaixaController::class, 'search'])->name('fluxoCaixa.search'); // BUSCA PARAMETRIZADA
    Route::post('/Caixa', [SaidaCaixaController::class, 'store'])->name('Saída-Caixa'); // CADASTRAR SAIDAS DE CAIXA
    Route::get('/scaixa-detalhe/{id}', [SaidaCaixaController::class, 'show'])->name('detalheSC'); // MOSTRAR DETALHE DA SAIDA DE CAIXA
    Route::get('/scaixa-imprimir/{id}', [SaidaCaixaController::class, 'print'])->name('imprimirSC'); // IMPRIMIR SAIDA DE CAIXA
    Route::put('/scaixa/{id}', [SaidaCaixaController::class, 'update'])->name('scaixa.update'); // ATUALIZAR SAIDA DE CAIXA
    
    // Comprovativos de Pagamento
    Route::get('/comprovativos', [ComprovativoPagamentoController::class, 'index'])->name('comprovativos.pagamento'); // LISTAR COMPROVATIVOS
    Route::get('/comprovativos-search', [ComprovativoPagamentoController::class, 'search'])->name('comprovativos.search'); // BUSCA PARAMETRIZADA
    Route::post('/comprovativos', [ComprovativoPagamentoController::class, 'store'])->name('comprovativos.store'); // CADASTRAR COMPROVATIVO
    Route::get('/comprovativos/{id}', [ComprovativoPagamentoController::class, 'show'])->name('comprovativos.show'); // MOSTRAR DETALHE DO COMPROVATIVO
    Route::put('/comprovativos/{id}', [ComprovativoPagamentoController::class, 'update'])->name('comprovativos.update'); // ATUALIZAR COMPROVATIVO
    Route::delete('/comprovativos/{id}', [ComprovativoPagamentoController::class, 'destroy'])->name('comprovativos.destroy'); // REMOVER COMPROVATIVO
    Route::put('/comprovativos/{id}/validar', [ComprovativoPagamentoController::class, 'validar'])->name('comprovativos.validar'); // VALIDAR/INVALIDAR COMPROVATIVO

    // Rotas de Utilizadores
    Route::get('/users', [UserController::class, 'index'])->name('users'); // LISTAR UTILIZADORES
    Route::post('/users', [UserController::class, 'store'])->name('users.store'); // CADASTRAR UTILIZADOR
    Route::get('/users/{id}', [UserController::class, 'show'])->name('users.show'); // VISUALIZAR UTILIZADOR
    Route::put('/users/{id}', [UserController::class, 'update'])->name('users.update'); // ATUALIZAR UTILIZADOR
    Route::delete('/users/{id}', [UserController::class, 'destroy'])->name('users.destroy'); // REMOVER UTILIZADOR

}); // FIM GRUPO DE ROTAS ADMINISTRAÇÃO

// =======================================================================================================================================================

// GRUPO DE ROTAS CLIENTES
Route::group(['middleware' => 'client'], function () {

    // Logout do APP
    Route::get('/logout', [AcessoController::class, 'logoutProcess'])->name('logoutProcess');

    // Rotas da homePage de clientes
    // Route::get('/HomeCliente',[HomeClienteController::class,'index'])->name("homeCliente");

    // Rotas de Pagamentos das Taxas
    // Route::get('/MinhasContas',[PagamentotaxasController::class,'index'])->name("minhasContas");

});
