<!-- Fullscreen Modal -->
<div class="modal fade exampleModalFullscreen" tabindex="-1" aria-labelledby="exampleModalFullscreenLabel" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #16bec9">
                <h5 class="modal-title" id="exampleModalFullscreenLabel">CADASTRAR NOVO UTILIZADOR</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <form class="row g-3" action="<?php echo e(route('users.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>

                    <!-- Dados Pessoais -->
                    <div class="col-md-12">
                        <h4>Dados Pessoais</h4>
                        <hr>
                    </div>

                    <div class="col-md-6">
                        <label for="name" class="form-label">Nome Completo</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>

                    <div class="col-md-3">
                        <label for="nID" class="form-label">Número de Identificação</label>
                        <input type="text" class="form-control" id="nID" name="nID" required>
                    </div>

                    <div class="col-md-3">
                        <label for="tipoID" class="form-label">Tipo de Documento</label>
                        <select class="form-select" id="tipoID" name="tipoID" required>
                            <option value="" selected disabled>Escolha...</option>
                            <option value="BI">BI</option>
                            <option value="Passaporte">Passaporte</option>
                            <option value="Outro">Outro</option>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="genero" class="form-label">Género</label>
                        <select class="form-select" id="genero" name="genero" required>
                            <option value="" selected disabled>Escolha...</option>
                            <option value="Masculino">Masculino</option>
                            <option value="Feminino">Feminino</option>
                            <option value="Outro">Outro</option>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="dataNasc" class="form-label">Data de Nascimento</label>
                        <input type="date" class="form-control" id="dataNasc" name="dataNasc" required>
                    </div>

                    <div class="col-md-3">
                        <label for="telefone" class="form-label">Telefone</label>
                        <input type="text" class="form-control" id="telefone" name="telefone" required>
                    </div>

                    <div class="col-md-3">
                        <label for="contactoPrimario" class="form-label">Contacto Primário</label>
                        <input type="text" class="form-control" id="contactoPrimario" name="contactoPrimario" required>
                    </div>

                    <div class="col-md-12">
                        <label for="obs" class="form-label">Observações</label>
                        <textarea class="form-control" id="obs" name="obs" rows="3"></textarea>
                    </div>

                    <!-- Dados de Acesso -->
                    <div class="col-md-12">
                        <h4>Dados de Acesso</h4>
                        <hr>
                    </div>

                    <div class="col-md-4">
                        <label for="email" class="form-label">E-mail</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>

                    <div class="col-md-4">
                        <label for="password" class="form-label">Senha</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                    </div>

                    <div class="col-md-4">
                        <label for="password_confirmation" class="form-label">Confirmar Senha</label>
                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
                    </div>

                    <div class="col-md-4">
                        <label for="tipoConta" class="form-label">Tipo de Conta</label>
                        <select class="form-select" id="tipoConta" name="tipoConta" required>
                            <option value="" selected disabled>Escolha...</option>
                            <option value="Administrador">Administrador</option>
                            <option value="Operador">Operador</option>
                            <option value="Cliente">Cliente</option>
                        </select>
                    </div>

                    <div class="col-md-8">
                        <label class="form-label">Permissões</label>
                        <div class="d-flex gap-3 mt-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="admin" name="admin">
                                <label class="form-check-label" for="admin">
                                    Administrador
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="client" name="client">
                                <label class="form-check-label" for="client">
                                    Cliente
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-12 text-end">
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Cadastrar Utilizador</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sincronizar o tipo de conta com as permissões de checkbox
        const tipoContaSelect = document.getElementById('tipoConta');
        const adminCheckbox = document.getElementById('admin');
        const clientCheckbox = document.getElementById('client');

        tipoContaSelect.addEventListener('change', function() {
            const selectedValue = this.value;
            
            // Reset checkboxes
            adminCheckbox.checked = false;
            clientCheckbox.checked = false;
            
            // Set appropriate checkbox based on selection
            if (selectedValue === 'Administrador') {
                adminCheckbox.checked = true;
            } else if (selectedValue === 'Cliente') {
                clientCheckbox.checked = true;
            }
        });
    });
</script>
<?php /**PATH C:\laragon\www\PetroSys\resources\views/Administracao/ComponentesAdmin/Users/Cpt_CreateUser.blade.php ENDPATH**/ ?>