<!-- Fullscreen Modal for Parametrized Search -->
<div class="modal fade exampleModalFullscreenSearch" tabindex="-1" aria-labelledby="exampleModalFullscreenSearchLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #0b6631">
                <h5 class="modal-title text-white" id="exampleModalFullscreenSearchLabel">BUSCA PARAMETRIZADA - SAÍDAS DE CAIXA</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="GET" action="<?php echo e(route('fluxoCaixa.search')); ?>" class="row g-3">
                    <!-- Date Range -->
                    <div class="col-md-6">
                        <h5>Período</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="start_date" class="form-label">Data Inicial</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo e(request('start_date')); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="end_date" class="form-label">Data Final</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo e(request('end_date')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Centro de Custo -->
                    <div class="col-md-6">
                        <h5>Centro de Custo</h5>
                        <div class="mb-3">
                            <label for="centro_custo" class="form-label">Selecione</label>
                            <select class="form-select" id="centro_custo" name="centro_custo">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $centrosCusto; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $centro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($centro->id); ?>" <?php echo e(request('centro_custo') == $centro->id ? 'selected' : ''); ?>>
                                        <?php echo e($centro->nome); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <!-- Valor Range -->
                    <div class="col-md-12">
                        <h5>Valor</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="min_valor" class="form-label">Valor Mínimo</label>
                                    <input type="number" step="0.01" class="form-control" id="min_valor" name="min_valor" placeholder="0.00" value="<?php echo e(request('min_valor')); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="max_valor" class="form-label">Valor Máximo</label>
                                    <input type="number" step="0.01" class="form-control" id="max_valor" name="max_valor" placeholder="0.00" value="<?php echo e(request('max_valor')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Referência e Descritivo -->
                    <div class="col-md-12">
                        <h5>Texto</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="referencia" class="form-label">Referência</label>
                                    <input type="text" class="form-control" id="referencia" name="referencia" placeholder="Buscar por referência" value="<?php echo e(request('referencia')); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="descritivo" class="form-label">Descrição</label>
                                    <input type="text" class="form-control" id="descritivo" name="descritivo" placeholder="Buscar por descrição" value="<?php echo e(request('descritivo')); ?>">
                                </div>
                            </div>
                            
                        </div>
                        
                        
                    </div>

                    <div class="col-12 text-end">
                        <a href="<?php echo e(route('fluxoCaixa')); ?>" class="btn btn-secondary">Limpar Filtros</a>
                        <button type="submit" class="btn btn-success"><i class="ri-search-line me-1"></i> Buscar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\PetroSys\resources\views/Administracao/ComponentesAdmin/SaidasCaixa/Cpt_BuscaParametrizada.blade.php ENDPATH**/ ?>