<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EmpresaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
         // Regras de validação do formulário de cadastro de empresas

        return [
            'nomeRegistro'=>'required',
            'nomeComercial'=> 'required',
            'nif'=> 'required',
            'email'=> 'required|email',
            'endereco'=> 'required',
            'cidade'=> 'required',
            'pais'=> 'required',
            'website'=> 'required',
            'logotipo'=> 'required',
            'documentacao'=> 'required',
            'contactoPrimario'=> 'required',
            'contactoSecundario'=> 'required',         
        ];
    }


    public function messages(): array
    {
        return[
            'nomeRegistro.required'=>'Campo Nome de Registo é obrigatório',
            'nomeComercial.required'=>'Campo Nome Comercial é obrigatório',
            'nif.required'=>'Campo NIF é obrigatório',
            'email.required'=>'Campo E-mail é obrigatório',
            'email.email'=>'Necessário enviar e-mail válido',
            'endereco.required'=>'Campo Endereço é obrigatório',
            'cidade.required'=>'Campo Cidade é obrigatório',
            'pais.required'=>'Campo País é obrigatório',
            'website.required'=>'Campo Website é obrigatório',
            'logotipo.required'=>'Campo Logotipo é obrigatório',
            'documentacao.required'=>'Campo Documentação é obrigatório',
            'contactoPrimario.required'=>'Campo Contacto Primário é obrigatório',
            'contactoSecundario.required'=>'Campo Contacto Secundário é obrigatório',
        ];

    }
}
