<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-theme="default" data-theme-colors="default">

<head>

    <meta charset="utf-8" />
    <title>PetroSys</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.png">

    <!-- Layout config Js -->
    <script src="assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="assets/css/custom.min.css" rel="stylesheet" type="text/css" />

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <style>
        .limit-text {
            white-space: nowrap; /* Impede que o texto quebre em várias linhas */
            overflow: hidden; /* Esconde o texto que ultrapassa o limite */
            text-overflow: ellipsis; /* Adiciona reticências ao texto que ultrapassa o limite */
            max-width: 230px; /* Define a largura máxima da célula */
        }
        
        .limit {
            white-space: nowrap; /* Impede que o texto quebre em várias linhas */
            overflow: hidden; /* Esconde o texto que ultrapassa o limite */
            text-overflow: ellipsis; /* Adiciona reticências ao texto que ultrapassa o limite */
            max-width: 150px; /* Define a largura máxima da célula */
        }
    </style>

</head>

<body>
<!-- Begin page -->
<div id="layout-wrapper">

    <header id="page-topbar">
    <div class="layout-width">
        <div class="navbar-header">
            <div class="d-flex">
                <!-- LOGO -->
                <div class="navbar-brand-box horizontal-logo">
                    <a href="<?php echo e(route('home')); ?>" class="logo logo-dark">
                        <span class="logo-sm">
                            <img src="assets/images/logo-sm.png" alt="" height="22">
                        </span>
                        <span class="logo-lg">
                            <img src="assets/images/logo-dark.png" alt="" height="17">
                        </span>
                    </a>
    
                    <a href="<?php echo e(route('home')); ?>" class="logo logo-light">
                        <span class="logo-sm">
                            <img src="assets/images/logo-sm.png" alt="" height="22">
                        </span>
                        <span class="logo-lg">
                            <img src="assets/images/logo-light.png" alt="" height="17">
                        </span>
                    </a>
                </div>
    
                <button type="button" class="btn btn-sm px-3 fs-16 header-item vertical-menu-btn topnav-hamburger material-shadow-none" id="topnav-hamburger-icon">
                    <span class="hamburger-icon">
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                </button>
    
                <!-- App Search-->
                <form class="app-search d-none d-md-block">
                    <div class="position-relative">
                        <input type="text" class="form-control" placeholder="Buscar..." autocomplete="off" id="search-options" value="">
                        <span class="mdi mdi-magnify search-widget-icon"></span>
                        <span class="mdi mdi-close-circle search-widget-icon search-widget-icon-close d-none" id="search-close-options"></span>
                    </div>
                    <div class="dropdown-menu dropdown-menu-lg" id="search-dropdown">
                        <div data-simplebar style="max-height: 320px;">
                            <!-- item-->
                            <div class="dropdown-header">
                                <h6 class="text-overflow text-muted mb-0 text-uppercase">Recent Searches</h6>
                            </div>
    
                            <div class="dropdown-item bg-transparent text-wrap">
                                <a href="index.html" class="btn btn-soft-secondary btn-sm rounded-pill">how to setup <i class="mdi mdi-magnify ms-1"></i></a>
                                <a href="index.html" class="btn btn-soft-secondary btn-sm rounded-pill">buttons <i class="mdi mdi-magnify ms-1"></i></a>
                            </div>
                            <!-- item-->
                            <div class="dropdown-header mt-2">
                                <h6 class="text-overflow text-muted mb-1 text-uppercase">Pages</h6>
                            </div>
    
                            <!-- item-->
                            <a href="javascript:void(0);" class="dropdown-item notify-item">
                                <i class="ri-bubble-chart-line align-middle fs-18 text-muted me-2"></i>
                                <span>Analytics Dashboard</span>
                            </a>
    
                            <!-- item-->
                            <a href="javascript:void(0);" class="dropdown-item notify-item">
                                <i class="ri-lifebuoy-line align-middle fs-18 text-muted me-2"></i>
                                <span>Help Center</span>
                            </a>
    
                            <!-- item-->
                            <a href="javascript:void(0);" class="dropdown-item notify-item">
                                <i class="ri-user-settings-line align-middle fs-18 text-muted me-2"></i>
                                <span>My account settings</span>
                            </a>
    
                            <!-- item-->
                            <div class="dropdown-header mt-2">
                                <h6 class="text-overflow text-muted mb-2 text-uppercase">Members</h6>
                            </div>
    
                            <div class="notification-list">
                                <!-- item -->
                                <a href="javascript:void(0);" class="dropdown-item notify-item py-2">
                                    <div class="d-flex">
                                        <img src="assets/images/users/avatar-2.jpg" class="me-3 rounded-circle avatar-xs" alt="user-pic">
                                        <div class="flex-grow-1">
                                            <h6 class="m-0">Angela Bernier</h6>
                                            <span class="fs-11 mb-0 text-muted">Manager</span>
                                        </div>
                                    </div>
                                </a>
                                <!-- item -->
                                <a href="javascript:void(0);" class="dropdown-item notify-item py-2">
                                    <div class="d-flex">
                                        <img src="assets/images/users/avatar-3.jpg" class="me-3 rounded-circle avatar-xs" alt="user-pic">
                                        <div class="flex-grow-1">
                                            <h6 class="m-0">David Grasso</h6>
                                            <span class="fs-11 mb-0 text-muted">Web Designer</span>
                                        </div>
                                    </div>
                                </a>
                                <!-- item -->
                                <a href="javascript:void(0);" class="dropdown-item notify-item py-2">
                                    <div class="d-flex">
                                        <img src="assets/images/users/avatar-5.jpg" class="me-3 rounded-circle avatar-xs" alt="user-pic">
                                        <div class="flex-grow-1">
                                            <h6 class="m-0">Mike Bunch</h6>
                                            <span class="fs-11 mb-0 text-muted">React Developer</span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
    
                        <div class="text-center pt-3 pb-1">
                            <a href="pages-search-results.html" class="btn btn-primary btn-sm">View All Results <i class="ri-arrow-right-line ms-1"></i></a>
                        </div>
                    </div>
                </form>
            </div>
    
            <div class="d-flex align-items-center">
    
                <div class="dropdown d-md-none topbar-head-dropdown header-item">
                    <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle" id="page-header-search-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="bx bx-search fs-22"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0" aria-labelledby="page-header-search-dropdown">
                        <form class="p-3">
                            <div class="form-group m-0">
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Buscar..." aria-label="Recipient's username">
                                    <button class="btn btn-primary" type="submit"><i class="mdi mdi-magnify"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
    
                
    
                
               
    
                <div class="ms-1 header-item d-none d-sm-flex">
                    <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle" data-toggle="fullscreen">
                        <i class='bx bx-fullscreen fs-22'></i>
                    </button>
                </div>
    
                <div class="ms-1 header-item d-none d-sm-flex">
                    <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle light-dark-mode">
                        <i class='bx bx-moon fs-22'></i>
                    </button>
                </div>
    
                <div class="dropdown topbar-head-dropdown ms-1 header-item" id="notificationDropdown">
                    <button type="button" class="btn btn-icon btn-topbar material-shadow-none btn-ghost-secondary rounded-circle" id="page-header-notifications-dropdown" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-haspopup="true" aria-expanded="false">
                        <i class='bx bx-bell fs-22'></i>
                        <span class="position-absolute topbar-badge fs-10 translate-middle badge rounded-pill bg-danger">3<span class="visually-hidden">unread messages</span></span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0" aria-labelledby="page-header-notifications-dropdown">
    
                        <div class="dropdown-head bg-primary bg-pattern rounded-top">
                            <div class="p-3">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h6 class="m-0 fs-16 fw-semibold text-white"> Notificões </h6>
                                    </div>
                                    <div class="col-auto dropdown-tabs">
                                        <span class="badge bg-light text-body fs-13"> 3 Novas</span>
                                    </div>
                                </div>
                            </div>
    
                        </div>
    
                        
                    </div>
                </div>
    
                <div class="dropdown ms-sm-3 header-item topbar-user">
                    <button type="button" class="btn material-shadow-none" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <span class="d-flex align-items-center">
                            <img class="rounded-circle header-profile-user" src="assets/images/users/avatar-1.jpg" alt="Header Avatar">
                            <span class="text-start ms-xl-2">
                                <span class="d-none d-xl-inline-block ms-1 fw-medium user-name-text">
                                    
                                     
                                <?php if(auth()->check()): ?>

                                <?php echo e(auth()->user()->name); ?>

                                    
                                <?php endif; ?>
                                </span>
                                <span class="d-none d-xl-block ms-1 fs-12 user-name-sub-text">Gestor PA</span>
                            </span>
                        </span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end">
                        <!-- item-->
                        <h6 class="dropdown-header">Bem-vindo(a) Valery Tseyi!</h6>
                        <a class="dropdown-item" href="#"><i class="mdi mdi-account-circle text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Perfil</span></a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#"><i class="mdi mdi-wallet text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Balanço : <b>5971.67 AOA</b></span></a>
                        <a class="dropdown-item" href="#"><span class="badge bg-success-subtle text-success mt-1 float-end">Novo</span><i class="mdi mdi-cog-outline text-muted fs-16 align-middle me-1"></i> <span class="align-middle">Configurações</span></a>
                        <a class="dropdown-item" href="<?php echo e(route('logoutProcess')); ?>"><i class="mdi mdi-logout text-muted fs-16 align-middle me-1"></i> <span class="align-middle" data-key="t-logout">Logout</span></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </header>
    
    <!-- removeNotificationModal -->
    <div id="removeNotificationModal" class="modal fade zoomIn" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="NotificationModalbtn-close"></button>
            </div>
            <div class="modal-body">
                <div class="mt-2 text-center">
                    <lord-icon src="https://cdn.lordicon.com/gsqxdxog.json" trigger="loop" colors="primary:#f7b84b,secondary:#f06548" style="width:100px;height:100px"></lord-icon>
                    <div class="mt-4 pt-2 fs-15 mx-4 mx-sm-5">
                        <h4>Are you sure ?</h4>
                        <p class="text-muted mx-4 mb-0">Are you sure you want to remove this Notification ?</p>
                    </div>
                </div>
                <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                    <button type="button" class="btn w-sm btn-light" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn w-sm btn-danger" id="delete-notification">Yes, Delete It!</button>
                </div>
            </div>
    
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
    <!-- ========== FIM TOP MENU ========== -->
    
    
    <!-- ======================================================================================================================== -->
    
    <!-- ========== AREA DE MENU ADMIN DO SISTEMA ========== -->
        <div class="app-menu navbar-menu">
            <!-- LOGO -->
            <div class="navbar-brand-box">
                <!-- Dark Logo-->
                <a href="<?php echo e(route('home')); ?>" class="logo logo-dark">
                    <span class="logo-sm">
                        <img src="assets/images/logo-sm.png" alt="" height="32">
                    </span>
                    <span class="logo-lg">
                        <img src="assets/images/logo-dark.png" alt="" height="26">
                    </span>
                </a>
                <!-- Light Logo-->
                <a href="<?php echo e(route('home')); ?>" class="logo logo-light">
                    <span class="logo-sm">
                        <img src="assets/images/logo-sm.png" alt="" height="32">
                    </span>
                    <span class="logo-lg">
                        <img src="assets/images/logo-light.png" alt="" height="26">
                    </span>
                </a>
                <button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover" id="vertical-hover">
                    <i class="ri-record-circle-line"></i>
                </button>
            </div>
    
            
            <div id="scrollbar">
                <div class="container-fluid">
    
    
                    <div id="two-column-menu">
                    </div>
                    <ul class="navbar-nav" id="navbar-nav">
                        <li class="menu-title"><span data-key="t-menu">Menu</span></li>
                        
                        
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth112" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth112">
                                <i class="  ri-dashboard-fill"></i><span data-key="t-Dashboards">Dashboards</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth112">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('home')); ?>" class="nav-link" data-key="t-Gestão de Utilizadores"> SERVLUANDA,Lda - PAHONGA
                                        </a>
                                        
                                    </li>
                                   
                                    
                                    
                                </ul>
                            </div>
                        </li>
    
                        <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-Paginas">Gestão do PA</span></li>
                        
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth1" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth1">
                                <i class="  ri-briefcase-4-fill"></i> <span data-key="t-Administrativa">Administrativa</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth1">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="#sidebarCrm" class="nav-link" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarCrm" data-key="t-level-2.2"> Tabelas Auxiliares
                                        </a>
                                        <div class="collapse menu-dropdown" id="sidebarCrm">
                                            <ul class="nav nav-sm flex-column">
                                                <li class="nav-item">
                                                    <a href="" class="nav-link" data-key="t-empresa"> Empresa
                                                    </a>
                                                </li>
                                                <li class="nav-item">
                                                    <a href="" class="nav-link" data-key="t-Banco"> Banco
                                                    </a>
                                                </li>                                              
                                               
                                            </ul>
                                        </div>
                                    </li>
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Contratos"> Contratos
                                        </a>
                                        
                                    </li>
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Serviços"> Serviços
                                        </a>
                                        
                                    </li>
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Fornecedores"> Fornecedores
                                        </a>
                                        
                                    </li>
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Clientes"> Clientes
                                        </a>
                                        
                                    </li>
                                    
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Notificações"> Notificações
                                        </a>
                                        
                                    </li>
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Património"> Património
                                        </a>
                                        
                                    </li>
                                    
                                </ul>
                            </div>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth">
                                <i class=" ri-refund-2-line"></i> <span data-key="t-Finanças">Financeira</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('fluxoCaixa')); ?>" class="nav-link" data-key="t-Saída de Caixa"> Saída de Caixa
                                        </a>
                                        
                                    </li>
                                    
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('comprovativos.pagamento')); ?>" class="nav-link" data-key="t-Extrato de Conta"> Comprovativos de Pagamento
                                        </a>
                                        
                                    </li>
                                   

                                    
                                </ul>
                            </div>
                        </li>
                        
                        
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth12" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth12">
                                <i class="   ri-newspaper-line"></i> <span data-key="t-Definições">Relatórios</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth12">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Gestão de Utilizadores"> Gestão de Arquivo
                                        </a>
                                        
                                    </li>
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Serviços"> Fechos de Contas
                                        </a>
                                        
                                    </li>
                                    
                                    
                                </ul>
                            </div>
                        </li>
                       
                        <li class="menu-title"><i class="ri-more-fill"></i> <span data-key="t-Paginas">Configurações do App</span></li>
                       
                        <li class="nav-item">
                            <a class="nav-link menu-link" href="#sidebarAuth11" data-bs-toggle="collapse" role="button" aria-expanded="false" aria-controls="sidebarAuth11">
                                <i class="   ri-settings-4-fill"></i> <span data-key="t-Definições">Definições</span>
                            </a>
                            <div class="collapse menu-dropdown" id="sidebarAuth11">
                                <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                       <a href="<?php echo e(route('users')); ?>" class="nav-link" data-key="t-Gestão de Utilizadores"> Gestão de Utilizadores
                                        </a>
                                        
                                    </li>
                                    <li class="nav-item">
                                        <a href="#" class="nav-link" data-key="t-Serviços"> Backups
                                        </a>
                                        
                                    </li>
                                    
                                    
                                </ul>
                            </div>
                        </li>
                        
    
                        
    
                    </ul>
                </div>
                <!-- Sidebar -->
            </div>

         
    
            <div class="sidebar-background"></div>
        </div>
        <!-- Left Sidebar End -->
        <!-- Vertical Overlay-->
        <div class="vertical-overlay"></div>
    
    <!-- ========== FIM AREA DE MENU DO SISTEMA ========== -->
   

<!-- ======================================================================================================================== -->



    <!--ÁREA PARA CARREGAR O CONTEÚDO DA PÁGINA COM ACESSO DE ADMIN-->

<?php echo $__env->yieldContent('Conteudo'); ?>

<!-- FIM ÁREA PARA CARREGAR O CONTEÚDO DA PÁGINA COM ACESSO DE ADMIN-->


<!-- RODAPÉ -->


    
<!--start back-to-top-->

<button onclick="topFunction()" class="btn btn-primary btn-icon" id="back-to-top">
    <i class="ri-arrow-up-line"></i>
</button>

<!-- FIM back-to-top-->


<!-- JAVASCRIPT -->
<!-- JAVASCRIPT -->
<script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/libs/simplebar/simplebar.min.js"></script>
<script src="assets/libs/node-waves/waves.min.js"></script>
<script src="assets/libs/feather-icons/feather.min.js"></script>
<script src="assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
<script src="assets/js/plugins.js"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>


<!--datatable js-->
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>



<script src="assets/js/pages/datatables.init.js"></script>

 <!-- apexcharts -->
 <script src="assets/libs/apexcharts/apexcharts.min.js"></script>

 <!-- projects js -->
 <script src="assets/js/pages/dashboard-projects.init.js"></script>

 <!-- App js -->
 <script src="assets/js/app.js"></script>


 <script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
   
    // Assinatura
    const canvas = document.getElementById('assinatura');
    const signaturePad = new SignaturePad(canvas);

    document.getElementById('limpar-assinatura').addEventListener('click', function() {
        signaturePad.clear();
    });

    document.getElementById('salvar').addEventListener('click', function() {
        document.getElementById('assinatura-input').value = signaturePad.toDataURL();
    });

    document.querySelector('form').addEventListener('submit', function() {
        document.getElementById('assinatura-input').value = signaturePad.toDataURL();
    });
</script>

<script>
    $(document).ready(function() {
        // Captura o clique nos botões que abrem a modal
        $('button[data-bs-toggle="modal"]').on('click', function() {
            var saidaId = $(this).data('id'); // Obtém o ID da saída de caixa

            // Faz a requisição AJAX para buscar os detalhes
            $.ajax({
                url: '/petrosys/public/scaixa-detalhe/' + saidaId, // Rota para buscar os detalhes
                method: 'GET',
                success: function(response) {
                    
                    // Preenche a modal com os dados da resposta
                    $('#referencia').text(response.referencia);
                    $('#data').text(response.data);
                    $('#descritivo').text(response.descritivo);
                    $('#observacao').text(response.observacao || 'N/A');
                    $('#valorK').text(parseFloat(response.valor).toLocaleString('pt-BR', {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2
                    }));
                    $('#centroCusto').text(response.centro_custo.nome); // Assumindo relacionamento
                    $('#usuario').text(response.user.name); // Assumindo relacionamento
                    $('#recebidoPor').text(response.recebido_por);
                    $('#statusK').text(response.status)
                    
                    console.log(response); 

                   
                    if (response.suporte_documental) {
                        document.getElementById('suporteDocumental').src = "Doc/ComprovativoSaidaCaixa/" + response.suporte_documental; 
                     
                    }else {
                        document.getElementById('suporteDocumental').src = "Doc/ComprovativoSaidaCaixa/Exemplar.pdf"; // Define um valor padrão
                    }

                  
                
                    if (response.assinatura) {
                     document.getElementById('assinaturaK').src = response.assinatura; // Usa textContent para definir o texto
                    } else {
                      document.getElementById('assinaturaK').src = "data:image/png;base64,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"; // Define um valor padrão
                    }
                },
               
                error: function(xhr) {
                    console.error('Erro ao buscar detalhes da saída de caixa.');
                }
            });
        });
    });
</script>






 </body>
 
 </html>
<?php echo $__env->make('Layout.Rodape', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /mnt/home1/giscardt/servluandapa/petrosys/resources/views/Layout/LayoutBaseAdmin.blade.php ENDPATH**/ ?>