<!-- Modal de Edição de Comprovativo de Pagamento -->
<div class="modal fade" id="modalEditar" tabindex="-1" aria-labelledby="modalEditarLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEditarLabel">Editar Comprovativo de Pagamento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="form-editar" action="" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-12 mb-3">
                            <label class="form-label">Comprovativo Atual</label>
                            <div class="mb-2">
                                <a id="link-doc-atual" href="" target="_blank" class="btn btn-sm btn-outline-primary">
                                    <i class="ri-file-line me-1"></i>Visualizar Comprovativo Atual
                                </a>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label for="arquivo_comprovativo_edit" class="form-label">Novo Arquivo (opcional)</label>
                            <input type="file" class="form-control" id="arquivo_comprovativo_edit" name="arquivo_comprovativo" accept=".pdf,.jpg,.jpeg,.png">
                            <small class="text-muted">Formatos aceitos: PDF, JPG, JPEG, PNG (máx. 2MB)</small>
                        </div>
                        <div class="col-md-6">
                            <label for="data_hora_edit" class="form-label">Data e Hora do Pagamento *</label>
                            <input type="datetime-local" class="form-control" id="data_hora_edit" name="data_hora" required>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="banco_origem_id_edit" class="form-label">Banco de Origem *</label>
                            <select class="form-select" id="banco_origem_id_edit" name="banco_origem_id" required>
                                <option value="">Selecione um banco</option>
                                <?php $__currentLoopData = $bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($banco->id); ?>"><?php echo e($banco->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="banco_destino_id_edit" class="form-label">Banco de Destino *</label>
                            <select class="form-select" id="banco_destino_id_edit" name="banco_destino_id" required>
                                <option value="">Selecione um banco</option>
                                <?php $__currentLoopData = $bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($banco->id); ?>"><?php echo e($banco->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="users_id_edit" class="form-label">Funcionário que Acompanhou o Pagamento *</label>
                            <select class="form-select" id="users_id_edit" name="users_id" required>
                                <option value="">Selecione um funcionário</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="observacao_edit" class="form-label">Observação</label>
                            <textarea class="form-control" id="observacao_edit" name="observacao" rows="3"></textarea>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <p class="text-muted mb-0"><small>* Campos obrigatórios</small></p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Atualizar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Configura o modal de edição
    var modalEditar = document.getElementById('modalEditar');
    modalEditar.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var id = button.getAttribute('data-id');
        
        // Define a ação do formulário
        document.getElementById('form-editar').action = `/comprovativos/${id}`;
        
        // Faz requisição AJAX para obter os detalhes do comprovativo
        fetch(`/comprovativos/${id}`)
            .then(response => response.json())
            .then(data => {
                // Configura o link para o documento atual
                document.getElementById('link-doc-atual').href = `/Doc/ComprovativosPagamento/${data.arquivo_comprovativo}`;
                
                // Formata a data e hora para o formato esperado pelo input datetime-local
                const dataHora = new Date(data.data_hora);
                const ano = dataHora.getFullYear();
                const mes = String(dataHora.getMonth() + 1).padStart(2, '0');
                const dia = String(dataHora.getDate()).padStart(2, '0');
                const hora = String(dataHora.getHours()).padStart(2, '0');
                const minutos = String(dataHora.getMinutes()).padStart(2, '0');
                
                document.getElementById('data_hora_edit').value = `${ano}-${mes}-${dia}T${hora}:${minutos}`;
                
                // Seleciona os bancos nos dropdowns
                document.getElementById('banco_origem_id_edit').value = data.banco_origem_id;
                document.getElementById('banco_destino_id_edit').value = data.banco_destino_id;
                
                // Seleciona o funcionário no dropdown
                document.getElementById('users_id_edit').value = data.users_id;
                
                // Preenche a observação
                document.getElementById('observacao_edit').value = data.observacao;
            })
            .catch(error => {
                console.error('Erro ao carregar dados:', error);
                Swal.fire('Erro', 'Não foi possível carregar os detalhes do comprovativo', 'error');
            });
    });
});
</script>
<?php /**PATH C:\laragon\www\PetroSys\resources\views/Administracao/ComponentesAdmin/ComprovativosPagamento/Cpt_Editar.blade.php ENDPATH**/ ?>