<?php $__env->startSection('Conteudo'); ?>
<div class="main-content">

    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SERVLUANDA,Lda - PA HONGA</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
                                <li class="breadcrumb-item active"> Comprovativos de Pagamento</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            
                    <!-- start page title -->
                    
                    <!-- end page title -->
                    
                    <!-- Flash message -->
                    <?php if(session('msg')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="mdi mdi-check-all me-2"></i> <?php echo e(session('msg')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>
                    
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="mdi mdi-block-helper me-2"></i> <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>
                    <!-- End Flash message -->

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row mb-4">
                                        <div class="col-12 d-flex justify-content-between align-items-center">
                                            <h4 class="card-title">Gestão de Comprovativos de Pagamento</h4>
                                            <div>
                                                <!-- Botão para adicionar novo comprovativo -->
                                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalCadastro">
                                                    <i class="ri-add-line align-middle me-1"></i> Novo Comprovativo
                                                </button>
                                                
                                                <!-- Botão para busca parametrizada -->
                                                <button type="button" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#modalBuscaParametrizada">
                                                    <i class="ri-search-line align-middle me-1"></i> Busca Parametrizada
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Tabela de Comprovativos -->
                                    <div class="table-responsive">
                                        <table class="table table-hover mb-0">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th>Arquivo</th>
                                                    <th>Data e Hora</th>
                                                    <th>Banco de Origem</th>
                                                    <th>Banco de Destino</th>
                                                    <th>Observação</th>
                                                    <th>Registrado por</th>
                                                    <th>Status</th>
                                                    <th>Validado por</th>
                                                    <th>Ações</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(count($comprovativos) > 0): ?>
                                                    <?php $__currentLoopData = $comprovativos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comprovativo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($comprovativo->id); ?></td>
                                                            <td>
                                                                <a href="<?php echo e(asset('/petrosys/public/Doc/ComprovativosPagamento/' . $comprovativo->arquivo_comprovativo)); ?>" target="_blank">
                                                                    <i class="ri-file-line me-1"></i>Ver Arquivo
                                                                </a>
                                                            </td>
                                                            <td><?php echo e(\Carbon\Carbon::parse($comprovativo->data_hora)->format('d-m-Y - H:i:s')); ?></td>
                                                            <td class="limit-text"><?php echo e($comprovativo->bancoOrigem->nome); ?></td>
                                                            <td class="limit-text"><?php echo e($comprovativo->bancoDestino->nome); ?></td>
                                                            <td><?php echo e($comprovativo->observacao); ?></td>
                                                            <td><?php echo e($comprovativo->user->name); ?></td>
                                                            <td>
                                                                <?php if($comprovativo->status == 'pendente'): ?>
                                                                    <span class="badge bg-warning">Pendente</span>
                                                                <?php elseif($comprovativo->status == 'validado'): ?>
                                                                    <span class="badge bg-success">Validado</span>
                                                                <?php else: ?>
                                                                    <span class="badge bg-danger">Invalidado</span>
                                                                <?php endif; ?>
                                                            </td>
                                                            <td><?php echo e($comprovativo->validador ? $comprovativo->validador->name : 'N/A'); ?></td>
                                                            <td class="text-muted">
                                                                <!-- Grupo de Botões -->
                                                                <button type="button" class="btn btn-primary btn-icon waves-effect waves-light" 
                                                                    data-bs-toggle="modal" data-bs-target="#modalVisualizar" data-id="<?php echo e($comprovativo->id); ?>"
                                                                    title="Visualizar">
                                                                    <i class="ri-eye-line"></i>
                                                                </button>
                                                                
                                                                <button type="button" class="btn btn-success btn-icon waves-effect waves-light" 
                                                                    data-bs-toggle="modal" data-bs-target="#modalEditar" data-id="<?php echo e($comprovativo->id); ?>"
                                                                    title="Editar">
                                                                    <i class="ri-file-edit-line"></i>
                                                                </button>
                                                                
                                                                <!-- Botão para Validar/Invalidar -->
                                                                <button type="button" class="btn btn-info btn-icon waves-effect waves-light" 
                                                                    data-bs-toggle="modal" data-bs-target="#modalValidar" data-id="<?php echo e($comprovativo->id); ?>"
                                                                    title="Validar/Invalidar">
                                                                    <i class="ri-checkbox-circle-line"></i>
                                                                </button>
                                                                
                                                                <button type="button" class="btn btn-danger btn-icon waves-effect waves-light delete-btn" 
                                                                    data-id="<?php echo e($comprovativo->id); ?>" title="Excluir">
                                                                    <i class="ri-delete-bin-6-line"></i>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="9" class="text-center">Nenhum comprovativo de pagamento registado.</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <!-- Paginação -->
                                    <div class="d-flex justify-content-center mt-4">
                                        <?php echo e($comprovativos->links()); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container-fluid -->

                <!-- Incluir os componentes de modais -->
                <?php echo $__env->make("Administracao.ComponentesAdmin.ComprovativosPagamento.Cpt_Cadastro", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make("Administracao.ComponentesAdmin.ComprovativosPagamento.Cpt_Visualizar", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make("Administracao.ComponentesAdmin.ComprovativosPagamento.Cpt_Editar", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make("Administracao.ComponentesAdmin.ComprovativosPagamento.Cpt_Validar", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make("Administracao.ComponentesAdmin.ComprovativosPagamento.Cpt_BuscaParametrizada", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <!-- Form de exclusão -->
            <form id="delete-form" action="" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
            </form>

            <script>
                // Script para exclusão com confirmação
                document.addEventListener('DOMContentLoaded', function() {
                    const deleteButtons = document.querySelectorAll('.delete-btn');
                    
                    deleteButtons.forEach(btn => {
                        btn.addEventListener('click', function() {
                            const id = this.getAttribute('data-id');
                            
                            Swal.fire({
                                title: 'Tem certeza?',
                                text: "Esta ação não pode ser revertida!",
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#d33',
                                cancelButtonColor: '#3085d6',
                                confirmButtonText: 'Sim, excluir!',
                                cancelButtonText: 'Cancelar'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    const form = document.getElementById('delete-form');
                                    form.action = `/petrosys/public/comprovativos/${id}`;
                                    form.submit();
                                }
                            });
                        });
                    });
                });
            </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.LayoutBaseAdmin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /mnt/home1/giscardt/servluandapa/petrosys/resources/views/Administracao/ComprovativosPagamento.blade.php ENDPATH**/ ?>