<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Http;
use PHPUnit\Util\Exception;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function enviarNotificacaoCelular($telefone, $mensagem){
        try {
            $response = Http::post('https://telcosms.co.ao/send_message', [
                'message' => [
                    'api_key_app' =>  'qasaeee7f4c97f043a2cd785647a2',
                    'phone_number' => $telefone,
                    'message_body' => $mensagem,
                ]
            ]);
            if (str_contains($response['status'], '200')) {
                return true;
            }
        } catch (Exception $th) {
            return false;
        }
        return false;
    }
}
