<?php

namespace App\Http\Controllers;

use App\Http\Requests\ClienteRequest;
use App\Http\Requests\StoreSaidaCaixaRequest;
use App\Http\Requests\UtilizadorRequest;
use App\Models\CentroCusto;
use App\Models\Pessoa;
use App\Models\Quadra;
use App\Models\Rua;
use App\Models\SaidaCaixa;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;



class SaidaCaixaController extends Controller
{
    //  Mostra a view da listagem dos promitentes compradores e Cliente 
    public function index(){
        
        // Recupera todos os registros da BD Saidas de Caixa
        $saidas = SaidaCaixa::orderBy('id', 'desc')->with(['centroCusto', 'user'])->paginate(6);
        $ultimoregisto = SaidaCaixa::orderBy('id', 'desc')->first();

      // Recupera todos os centros de custos
        $centrosCusto = CentroCusto::all();

        // Recupera todos os utilizadores
        $users = User::all();
        return view('Administracao.SaidaCaixa', compact('saidas', 'centrosCusto', 'users', 'ultimoregisto'));
      
   }

   public function store(StoreSaidaCaixaRequest $request){

        // Validar formulario de cadastro das Saidas de Caixa
        $request->validated();

        //dd( $request);

        // Cadastrando a saida de caixa no banco de Dados
        $saidaCaixa = new SaidaCaixa;

        $saidaCaixa->referencia = $request->referencia; 
        $saidaCaixa->data = $request->data;
        $saidaCaixa->descritivo = $request->descritivo;
        $saidaCaixa->observacao = $request->observacao;
        $saidaCaixa->valor = $request->valor;
        $saidaCaixa->centros_custo_id = $request->centros_custo_id;
        $saidaCaixa->users_id = $request->users_id;
        $saidaCaixa->recebido_por = $request->recebido_por;
        $saidaCaixa->status = 'on';  // Status on - Validação da data da saida de caixa
        $saidaCaixa->assinatura=$request->assinatura;

        //UPLOAD DOCUMENTO DO SUPORTE DOCUMENTAL

        if($request->hasFile('suporte_documental') && $request->file('suporte_documental')->isValid()){

            $requestDoc = $request->suporte_documental; // Endereço do documento 
            $extensaoDoc = $requestDoc->extension(); // Extensão dO DOCUMENTO 

            $novoNomeDoc=md5($requestDoc->getClientOriginalName().strtotime('now')).".".$extensaoDoc; // Novo nome do doc no sistema
            $requestDoc->move(public_path('Doc/ComprovativoSaidaCaixa'),$novoNomeDoc); // Move pra para de imagens do sistema

            $saidaCaixa->suporte_documental=$novoNomeDoc;      
        }

        else{

            $saidaCaixa->suporte_documental=''; 
        }
        
        //dd($saidaCaixa);
        $saidaCaixa->save();

        $ultimoregisto = SaidaCaixa::orderBy('id', 'desc')->first();

       
        return redirect()->route('fluxoCaixa',compact('ultimoregisto'))->with('msg', 'Saída de Caixa cadastrada com sucesso!');
      
   }

   public function show($id)
    {
        $saidaCaixa = SaidaCaixa::with(['centroCusto', 'user'])->findOrFail($id);

       // dd($saidaCaixa);
        return response()->json($saidaCaixa);
        
    }

    public function print($id)
    {
        $dado = SaidaCaixa::with(['centroCusto', 'user'])->findOrFail($id);

        //dd($saidaCaixa);

       return view('Administracao.ComponentesAdmin.ModelosImpressao.Cpt_Mi_ReciboSC', compact('dado'));
    }   

}
