<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('saidas_caixa', function (Blueprint $table) {
            $table->id();
            $table->string('referencia', 50);
            $table->datetime('data');
            $table->string('descritivo', 255);
            $table->string('observacao', 255)->nullable();
            $table->decimal('valor', 10, 2);
            $table->foreignId('centros_custo_id')->constrained('centros_custo')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('users_id')->constrained('users')->onDelete('cascade')->onUpdate('cascade');
            $table->string('recebido_por', 50);
            $table->text('assinatura');
            $table->string('suporte_documental', 50);
            $table->string('status', 50);
            $table->timestamps();
        });
    }
    
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('saidas_caixa');
    }
};
