 @extends('Layout.LayoutBaseAdmin')


 @section('Conteudo')
   

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                                <h4 class="mb-sm-0">CONDOMÍNIO PLANALTO DO KINU</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
                                        <li class="breadcrumb-item active">Empresa</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <!-- Mensagens do sistema -->

                    @if (@session('msg'))
                        
                    

                    <script>
                        document.addEventListener('DOMContentLoaded',()=>{

                            Swal.fire({
                                title: "Pronto!",
                                text: "{{ session('msg') }}",
                                icon: "success"
                            });
                        });
                        
                    </script>

                     <!-- Mensagens do sistema -->
                        
                    @endif
                    

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="card card-height-100">
                                <div class="card-header d-flex align-items-center ">
                                    <h4 class="card-title flex-grow-1 mb-0">Empresa</h4>

                                    <div class="hstack flex-wrap gap-2 mb-3 mb-lg-0" >
    
                                        <button type="button" class="btn btn-primary btn-label"  data-bs-toggle="modal" data-bs-target=".exampleModalFullscreen"><i class=" ri-add-fill label-icon align-middle fs-16 me-2"></i>Nova Empresa &nbsp; &nbsp; &nbsp;</button>
                                       
                                    </div>
                                    
                                </div><!-- end cardheader -->
                                <div class="card-body">
                                    <div class="table-responsive table-card">
                                        <table  class="table table-nowrap table-centered align-middle">
                                            <thead class="bg-light text-muted">
                                                <tr>
                                                    <th scope="col">Logotipo da empresa</th>
                                                    <th scope="col">Nome Comercial</th>
                                                    <th scope="col">NIF</th>
                                                    <th scope="col">Endereço</th>
                                                    <th scope="col">E-mail</th>
                                                    <th scope="col">Contacto Primário</th>
                                                    <th scope="col">Contacto Secundário</th>
                                                    <th scope="col">Status</th>
                                                    <th scope="col" style="width: 10%;">Ações</th>
                                                </tr><!-- end tr -->
                                            </thead><!-- thead -->

                                            <tbody>
                                                @forelse ( $empresas as $projecto )
                                                
                                                <tr>
                                                    <td><img src="Img/sistema/{{ $projecto->nome }}" alt="" class="rounded avatar-xl material-shadow"></td>
                                                    <td class="fw-medium">{{ $projecto->nomeComercial}}</td>
                                                    <td class="fw-medium">{{ $projecto->nif}}</td>
                                                    <td class="text-muted">{{ $projecto->endereco}}</td>
                                                    <td class="text-muted">{{ $projecto->email}}</td>
                                                    <td class="text-muted">{{ $projecto->contactoPrimario}}</td>
                                                    <td class="text-muted">{{ $projecto->contactoSecundario}}</td>
                                                    <td>
                                                        @if ($projecto->status>0)
                                                            <span class="badge bg-success-subtle text-success">Activo</span>
                                                        @else
                                                            <span class="badge bg-warning-subtle text-warning">Desativado</span>

                                                        @endif
                                                    </td>
                                                    <td class="text-muted">
                                                        <!-- Buttons Group -->
                                                        <button type="button" class="btn btn-success waves-effect waves-light " data-bs-toggle="tooltip" data-bs-placement="top" title="Editar"><i class="ri-file-edit-line"></i></button>
                                                        <button type="button" class="btn btn-danger btn-icon waves-effect waves-light" data-bs-toggle="tooltip" data-bs-placement="top" title="Excluir"><i class="ri-delete-bin-6-line"></i></button>
                                                        
                                                    </td>
                                                </tr><!-- end tr -->

                                                   
                                                @empty

                                                <tr>
                                                    <td colspan="8">Nenhum registro foi encontrado...</td>
                                                    
                                                    </td>
                                                </tr><!-- end
                                                    
                                                @endforelse
                                                
                                               
                                            </tbody><!-- end tbody -->
                                        </table><!-- end table -->
                                    </div>
                                    <br>
                                    {{ $empresas->onEachSide(3)->links() }}

                                </div><!-- end card body -->
                            </div><!-- end card -->
                        </div><!-- end col -->


                       
                       
                    </div><!-- end row -->

                    

                </div>
                <!-- container-fluid -->
                @include("Administracao.ComponentesAdmin.Cpt_Empresa")
            </div>
           
          


   @endsection
  