<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'username'=>'required',
            'password'=>'required',
        ];
    }

    public function messages(): array
    {
        return[
            'username.required'=>'Campo Utilizador é obrigatório',
           // 'username.email'=>'Necessário enviar e-mail válido',
            'password.required'=>'Campo Palavra-passe é obrigatório',
        ];

    }
}
